<?php
session_start();

/* --- Security hardening --- */
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'super_admin') {
    header('Location: unauthorized.php');
    exit();
}
if (!isset($_SESSION['username'])) {
    $_SESSION['username'] = 'SuperAdmin'; // fallback
}
if (!isset($_SESSION['regenerated'])) {
    session_regenerate_id(true);
    $_SESSION['regenerated'] = true;
}

/* --- DB (optional) --- */
require_once 'db_connection.php';
// If you need counts for badges, query here and set variables.
// Example placeholders:
$counts = [
    'action_taken' => 0,
    'not_received_bh' => 0,
    'received_not_assigned' => 0,
    'not_seen_staff' => 0,
    'seen_no_action' => 0,
    'sent_all' => 0,
    'three_to_seven' => 0,
];

// Close if you don’t need the connection further on this page.
$conn->close();
?>
<!doctype html>
<html lang="en" data-bs-theme="light">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Super Admin Dashboard · Office Management System</title>

  <!-- Bootstrap 5.3 CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Font Awesome 6 -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" rel="stylesheet" referrerpolicy="no-referrer" />

  <style>
    :root{
      --brand-bg: #0b2545;
      --brand-bg-2: #13315c;
      --brand-accent: #2a6f97;
      --brand-accent-2: #61a5c2;
      --surface: #ffffff;
      --text-strong: #0b132b;
      --text-muted: #6c757d;
    }

    /* Layout */
    body{
      min-height:100vh;
      background: linear-gradient(135deg, var(--brand-bg) 0%, var(--brand-bg-2) 100%);
      background-attachment: fixed;
    }

    .app-shell{
      display:flex;
      min-height:100vh;
      width:100%;
    }

    /* Sidebar */
    .sidebar{
      width:280px;
      background: rgba(255,255,255,0.06);
      backdrop-filter: blur(6px);
      border-right: 1px solid rgba(255,255,255,0.12);
      color:#fff;
      position: sticky;
      top:0;
      height:100vh;
      padding: 1rem 0.75rem;
    }
    .brand{
      display:flex;
      align-items:center;
      gap:.65rem;
      padding:.5rem .5rem 1rem .5rem;
      border-bottom:1px solid rgba(255,255,255,0.12);
      margin-bottom:1rem;
    }
    .brand img{
      width:44px; height:44px; object-fit:contain;
      border-radius:8px; background: rgba(255,255,255,0.2);
    }
    .brand .title{
      line-height:1;
    }
    .brand .title small{
      display:block; color:#d1e7ff; opacity:.9;
    }

    .nav-link{
      color:#e2e6ea;
      border-radius:10px;
      padding:.65rem .85rem;
      display:flex;
      align-items:center;
      gap:.6rem;
      transition: all .15s ease;
    }
    .nav-link:hover, .nav-link.active{
      background: rgba(255,255,255,0.12);
      color:#fff;
      text-decoration:none;
      transform: translateX(2px);
    }
    .logout{
      color:#ffb3b3 !important;
    }

    /* Main */
    .main{
      flex:1;
      padding: 1.2rem;
      color:#fff;
    }

    /* Header card */
    .header-card{
      background: var(--surface);
      border-radius:16px;
      box-shadow: 0 10px 25px rgba(0,0,0,.15);
      padding: 1rem 1.25rem;
      margin-bottom: 1rem;
      color: var(--text-strong);
    }
    .header-card h1{
      font-size: clamp(1.1rem, 2vw, 1.35rem);
      margin:0;
      font-weight:700;
    }
    .header-card .sub{
      color: var(--text-muted);
      font-size:.95rem;
    }
    .logo-wrap img{
      width:56px; height:56px; object-fit:contain;
    }

    /* Section */
    .section-title{
      color:#e9f5ff;
      font-weight:700;
      letter-spacing:.3px;
      font-size:1rem;
      margin:1rem 0 .5rem;
      display:flex; align-items:center; gap:.5rem;
    }
    .section-title i{opacity:.85;}

    /* Action cards */
    .action-card{
      background: var(--surface);
      border:0;
      border-radius:16px;
      height:100%;
      box-shadow: 0 6px 18px rgba(0,0,0,.12);
      transition: transform .15s ease, box-shadow .15s ease;
    }
    .action-card:hover{
      transform: translateY(-3px);
      box-shadow: 0 12px 28px rgba(0,0,0,.18);
    }
    .action-card .card-body{
      display:flex; flex-direction:column; gap:.5rem;
    }
    .action-card .icon{
      font-size:1.35rem;
      width:2.25rem; height:2.25rem;
      display:grid; place-items:center;
      border-radius:10px;
      background: #eef6ff;
      color: var(--brand-accent);
    }
    .action-card .card-title{
      font-size:1rem; margin:0;
    }
    .badge-soft{
      background:#eef6ff; color:var(--brand-accent);
      font-weight:600;
    }

    /* Footer */
    .app-footer{
      color:#cfe2ff;
      font-size:.9rem;
      text-align:center;
      margin-top: 1rem;
      opacity:.85;
    }

    /* Utilities */
    .btn-toggle{
      display:none;
    }
    @media (max-width: 992px){
      .sidebar{
        position: fixed;
        left: -290px;
        transition: left .2s ease;
        z-index: 1040;
      }
      .sidebar.show{
        left:0;
      }
      .btn-toggle{
        display:inline-flex;
        align-items:center;
        gap:.5rem;
      }
      .main{
        padding-top: .75rem;
      }
      .backdrop{
        display:none;
        position:fixed; inset:0;
        backdrop-filter: blur(2px);
        background: rgba(0,0,0,.35);
        z-index:1035;
      }
      .backdrop.show{display:block;}
    }
  </style>
</head>
<body>
  <div class="app-shell">

    <!-- Sidebar -->
    <nav id="sidebar" class="sidebar">
      <div class="brand">
        <img src="logo1.png" alt="Logo left">
        <div class="title">
          <strong>Super Admin</strong>
          <small>Valvettiturai UC</small>
        </div>
      </div>

      <div class="mt-2">
        <a class="nav-link" href="staff.php">
          <i class="fa-solid fa-users"></i>
          Staff Letter Details
        </a>
        <a class="nav-link" href="view_letters_statistics.php">
          <i class="fa-solid fa-chart-pie"></i>
          View Letter Statistics
        </a>
        <a class="nav-link" href="report.php">
          <i class="fa-solid fa-file-lines"></i>
          Reports
        </a>
        <a class="nav-link" href="add_user.php">
          <i class="fa-solid fa-user-plus"></i>
          Add User
        </a>
        <a class="nav-link" href="view_users.php">
          <i class="fa-solid fa-eye"></i>
          View Users
        </a>
        <a class="nav-link" href="reassign.php">
          <i class="fa-solid fa-arrow-right-arrow-left"></i>
          Re-Assign
        </a>
        <a class="nav-link" href="insert_branch.php">
          <i class="fa-solid fa-plus-circle"></i>
          Insert Branch
        </a>
      </div>

      <hr class="border-light opacity-25">

      <a class="nav-link logout" href="logout.php">
        <i class="fa-solid fa-right-from-bracket"></i>
        Logout
      </a>
    </nav>

    <!-- Main -->
    <main class="main container-fluid">
      <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-2">
        <button class="btn btn-light btn-sm btn-toggle" type="button" id="openSidebar">
          <i class="fa-solid fa-bars"></i> Menu
        </button>

        <div class="header-card w-100">
          <div class="d-flex align-items-center justify-content-between">
            <div class="d-flex align-items-center gap-3">
              <div class="logo-wrap d-none d-sm-block">
                <img src="logo1.png" alt="Left Logo">
              </div>
              <div>
                <h1 class="mb-1">OFFICE MANAGEMENT SYSTEM — Valvettiturai Urban Council</h1>
                <div class="sub">
                  Welcome, <strong>Super Admin</strong>
                  <span id="username">
                    <?php echo htmlspecialchars($_SESSION['username']); ?>
                  </span>
                </div>
              </div>
            </div>
            <div class="logo-wrap">
              <img src="logo.jpg" alt="Right Logo">
            </div>
          </div>
        </div>
      </div>

      <!-- Letter Management -->
      <h2 class="section-title"><i class="fa-solid fa-envelope-open-text"></i> Letter Management</h2>
      <div class="row g-3">
        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
          <a class="text-decoration-none" href="action_yes_letters.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-check-circle"></i></div>
                <h3 class="card-title">Taken Action Letters</h3>
                <span class="badge badge-soft align-self-start">
                  <?php echo (int)$counts['action_taken']; ?>
                </span>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
          <a class="text-decoration-none" href="pending_with_branch_head.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-user-clock"></i></div>
                <h3 class="card-title">Not Received by Branch Head</h3>
                <span class="badge badge-soft align-self-start">
                  <?php echo (int)$counts['not_received_bh']; ?>
                </span>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
          <a class="text-decoration-none" href="received_not_forward_staff.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-arrow-right"></i></div>
                <h3 class="card-title">Received, Not Assigned to Staff</h3>
                <span class="badge badge-soft align-self-start">
                  <?php echo (int)$counts['received_not_assigned']; ?>
                </span>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
          <a class="text-decoration-none" href="not_seen_letters.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-eye-slash"></i></div>
                <h3 class="card-title">Not Seen by Staff</h3>
                <span class="badge badge-soft align-self-start">
                  <?php echo (int)$counts['not_seen_staff']; ?>
                </span>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
          <a class="text-decoration-none" href="seen_letters.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-eye"></i></div>
                <h3 class="card-title">Seen but No Action</h3>
                <span class="badge badge-soft align-self-start">
                  <?php echo (int)$counts['seen_no_action']; ?>
                </span>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
          <a class="text-decoration-none" href="sent_all_letters.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-paper-plane"></i></div>
                <h3 class="card-title">Sent — All Letters</h3>
                <span class="badge badge-soft align-self-start">
                  <?php echo (int)$counts['sent_all']; ?>
                </span>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4 col-xxl-3">
          <a class="text-decoration-none" href="3days.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-hourglass-half"></i></div>
                <h3 class="card-title">3–7 Days · No Action</h3>
                <span class="badge badge-soft align-self-start">
                  <?php echo (int)$counts['three_to_seven']; ?>
                </span>
              </div>
            </div>
          </a>
        </div>
      </div>

      <!-- File Management -->
      <h2 class="section-title"><i class="fa-solid fa-folder-open"></i> File Management</h2>
      <div class="row g-3">
        <div class="col-12 col-sm-6 col-lg-4">
          <a class="text-decoration-none" href="file_management_view.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-database"></i></div>
                <h3 class="card-title">View All Records</h3>
                <p class="mb-0 text-muted">Search, filter, and audit files.</p>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
          <a class="text-decoration-none" href="file_forward.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-paper-plane"></i></div>
                <h3 class="card-title">File Forward</h3>
                <p class="mb-0 text-muted">Forward files to branches / staff.</p>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
          <a class="text-decoration-none" href="system_backup.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-shield-halved"></i></div>
                <h3 class="card-title">System Backup</h3>
                <p class="mb-0 text-muted">Run & download backups safely.</p>
              </div>
            </div>
          </a>
        </div>
      </div>

      <!-- Reports -->
      <h2 class="section-title"><i class="fa-solid fa-chart-line"></i> Reports</h2>
      <div class="row g-3">
        <div class="col-12 col-sm-6 col-lg-4">
          <a class="text-decoration-none" href="view_reports.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-chart-column"></i></div>
                <h3 class="card-title">View Reports</h3>
                <p class="mb-0 text-muted">Dashboards & analytics.</p>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
          <a class="text-decoration-none" href="generate_report.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-file-circle-plus"></i></div>
                <h3 class="card-title">Generate Report</h3>
                <p class="mb-0 text-muted">Create periodical summaries.</p>
              </div>
            </div>
          </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-4">
          <a class="text-decoration-none" href="export_reports.php">
            <div class="card action-card">
              <div class="card-body">
                <div class="icon"><i class="fa-solid fa-file-export"></i></div>
                <h3 class="card-title">Export Reports</h3>
                <p class="mb-0 text-muted">PDF, Excel, CSV, and more.</p>
              </div>
            </div>
          </a>
        </div>
      </div>

      <div class="app-footer">
        © <?php echo date('Y'); ?> Valvettiturai Urban Council · Office Management System
      </div>
    </main>
  </div>

  <!-- Mobile backdrop -->
  <div id="backdrop" class="backdrop"></div>

  <!-- Bootstrap 5.3 JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

  <script>
    // Sidebar toggle for mobile
    const sidebar = document.getElementById('sidebar');
    const openBtn = document.getElementById('openSidebar');
    const backdrop = document.getElementById('backdrop');

    function toggleSidebar(show){
      if(show){
        sidebar.classList.add('show');
        backdrop.classList.add('show');
      }else{
        sidebar.classList.remove('show');
        backdrop.classList.remove('show');
      }
    }

    openBtn?.addEventListener('click', ()=> toggleSidebar(true));
    backdrop?.addEventListener('click', ()=> toggleSidebar(false));

    // Highlight active link by path
    const path = location.pathname.split('/').pop();
    document.querySelectorAll('.sidebar .nav-link').forEach(a=>{
      const href = a.getAttribute('href');
      if(href && href === path){ a.classList.add('active'); }
    });
  </script>
</body>
</html>
