<?php
session_start();

// Check if the user is logged in and has the correct role (either letter_admin or super_admin)
if (!isset($_SESSION['role']) || !in_array($_SESSION['role'], ['letter_admin', 'super_admin'])) {
    header('Location: unauthorized.php'); // Redirect to unauthorized page if role doesn't match
    exit();
}

// Include the database connection file
include 'db_connection.php';

// Initialize the count variables
$pending_count = 0;
$received_count = 0;
$seen_count = 0;
$action_count = 0;
$no_action_count = 0;
$not_seen_count = 0;

// Initialize filter variables
$start_date = $end_date = $branch_id = "";

// Prepare the query to count statuses (design-only changes below; logic unchanged)
$query = "SELECT 
            COUNT(CASE WHEN letters.status_branch_head = 'pending' THEN 1 END) AS pending_count,
            COUNT(CASE WHEN letters.status_branch_head = 'received' THEN 1 END) AS received_count,
            COUNT(CASE WHEN letters.seen = 1 THEN 1 END) AS seen_count,
            COUNT(CASE WHEN letters.action = 'yes' THEN 1 END) AS action_count,
            COUNT(CASE WHEN letters.action IS NULL OR letters.action = '' THEN 1 END) AS no_action_count,
            COUNT(CASE WHEN letters.seen IS NULL OR letters.seen = '' THEN 1 END) AS not_seen_count
          FROM letters
          WHERE 1";

// Apply date range filter if provided
if (isset($_POST['start_date']) && isset($_POST['end_date']) && $_POST['start_date'] != '' && $_POST['end_date'] != '') {
    $start_date = $_POST['start_date'];
    $end_date = $_POST['end_date'];
    $query .= " AND letters.letter_date BETWEEN '$start_date' AND '$end_date'";
}

// Apply branch filter if provided
if (isset($_POST['branch_id']) && $_POST['branch_id'] != '') {
    $branch_id = $_POST['branch_id'];
    $query .= " AND letters.branch_id = '$branch_id'";
}

// Execute the query
$result = $conn->query($query);

// Check if there are any results
if ($result) {
    $row = $result->fetch_assoc();
    $pending_count   = (int)$row['pending_count'];
    $received_count  = (int)$row['received_count'];
    $seen_count      = (int)$row['seen_count'];
    $action_count    = (int)$row['action_count'];
    $no_action_count = (int)$row['no_action_count'];
    $not_seen_count  = (int)$row['not_seen_count'];
} else {
    $pending_count = $received_count = $seen_count = $action_count = $no_action_count = $not_seen_count = 0;
}

// Fetch all branches for the filter dropdown
$branches = $conn->query("SELECT branch_id, branch_name FROM branches");

// Close the database connection
$conn->close();

// Back button target by role
$back = ($_SESSION['role'] === 'super_admin') ? 'super_admin_dashboard.php' : 'letter_admin_dashboard.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8"/>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Status Counts - Letter Admin</title>

  <!-- Bootstrap 4 -->
  <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
  <!-- Font Awesome 5 (stable with your classes) -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css"/>

  <style>
    :root{
      --brand:#2563eb; --brand-2:#60a5fa; --bg:#f4f7fb; --ink:#0b1320;
      --card-r:16px; --soft-shadow:0 14px 30px rgba(2,8,23,.08);
    }
    body{
      background:
        radial-gradient(70rem 70rem at 120% -20%, rgba(37,99,235,.08), transparent 60%),
        radial-gradient(70rem 70rem at -20% 120%, rgba(37,99,235,.06), transparent 60%),
        var(--bg);
      color: var(--ink);
      font-family: system-ui, -apple-system, Segoe UI, Roboto, "Helvetica Neue", Arial;
      padding-bottom: 40px; /* keep clear of footer */
    }

    /* Topbar */
    .topbar{
      position: sticky; top:0; z-index:1030;
      background: linear-gradient(135deg, var(--brand), var(--brand-2));
      color:#fff;
      box-shadow: 0 10px 24px rgba(37,99,235,.25);
      padding:.85rem 0;
      margin-bottom: 1rem;
    }
    .brand-title{ font-weight:800; letter-spacing:.2px; }
    .avatar-badge{
      background: rgba(255,255,255,.18);
      border: 1px solid rgba(255,255,255,.28);
      color:#fff;
    }

    /* Filter bar */
    .filter-card{
      background:#fff; border:1px solid rgba(2,8,23,.06);
      border-radius: var(--card-r); box-shadow: var(--soft-shadow);
    }
    .filter-card .form-control, .filter-card .custom-select{
      border-radius:10px;
    }

    /* Stat cards */
    .stats{
      display:grid; grid-template-columns: repeat(auto-fit,minmax(220px,1fr));
      gap: 16px; margin-bottom: 1.25rem;
    }
    .stat-card{
      border-radius: var(--card-r);
      color:#fff; text-decoration:none !important;
      box-shadow: var(--soft-shadow);
      transition: transform .12s ease, box-shadow .12s ease;
      display:block;
    }
    .stat-card:hover{ transform: translateY(-2px); box-shadow: 0 16px 40px rgba(2,8,23,.12); }
    .stat-body{ padding: 16px 18px; display:flex; align-items:center; justify-content:space-between; }
    .stat-label{ opacity:.9; font-weight:600; }
    .stat-value{ font-size:1.6rem; font-weight:800; line-height:1; }
    .stat-icon{ font-size:1.6rem; opacity:.9; }

    .stat-pending   { background: linear-gradient(135deg,#6366f1,#60a5fa); }
    .stat-received  { background: linear-gradient(135deg,#22c55e,#4ade80); }
    .stat-seen      { background: linear-gradient(135deg,#f59e0b,#fbbf24); }
    .stat-action    { background: linear-gradient(135deg,#06b6d4,#22d3ee); }
    .stat-noaction  { background: linear-gradient(135deg,#6b7280,#9ca3af); }
    .stat-notseen   { background: linear-gradient(135deg,#111827,#374151); }

    /* Footer (non-fixed so it doesn't overlap content) */
    footer{
      background:#0f172a; color:#cbd5e1;
      text-align:center; padding:12px 10px; margin-top: 28px;
      border-top: 1px solid rgba(255,255,255,.06);
    }
  </style>
</head>
<body>

<!-- Top bar -->
<div class="topbar">
  <div class="container d-flex align-items-center justify-content-between">
    <div class="d-flex align-items-center">
      <i class="fas fa-mail-bulk mr-2"></i>
      <div>
        <div class="brand-title">Letter Management – Status Report</div>
        <small class="text-white-75">Filter by date and branch, then drill down</small>
      </div>
    </div>
    <div class="d-flex align-items-center">
      <a href="<?php echo htmlspecialchars($back,ENT_QUOTES,'UTF-8'); ?>" class="btn btn-outline-light btn-sm mr-2">
        <i class="fas fa-arrow-left mr-1"></i> Back to Dashboard
      </a>
      <span class="badge avatar-badge">
        <i class="fas fa-user-shield mr-1"></i><?php echo htmlspecialchars($_SESSION['username']??'User'); ?>
        <span class="mx-1">•</span><?php echo htmlspecialchars($_SESSION['role']); ?>
      </span>
    </div>
  </div>
</div>

<div class="container">

  <!-- Filter Card -->
  <div class="filter-card p-3 p-md-4 mb-3">
    <form action="report.php" method="POST">
      <div class="form-row">
        <div class="form-group col-md-3">
          <label for="start_date" class="mb-1">Start Date</label>
          <input type="date" name="start_date" id="start_date" class="form-control" value="<?php echo htmlspecialchars($start_date); ?>">
        </div>
        <div class="form-group col-md-3">
          <label for="end_date" class="mb-1">End Date</label>
          <input type="date" name="end_date" id="end_date" class="form-control" value="<?php echo htmlspecialchars($end_date); ?>">
        </div>
        <div class="form-group col-md-3">
          <label for="branch_id" class="mb-1">Branch</label>
          <select name="branch_id" id="branch_id" class="custom-select">
            <option value="">Select Branch</option>
            <?php if ($branches && $branches->num_rows): ?>
              <?php while ($branch = $branches->fetch_assoc()): ?>
                <option value="<?php echo (int)$branch['branch_id']; ?>" <?php if ($branch_id == $branch['branch_id']) echo 'selected'; ?>>
                  <?php echo htmlspecialchars($branch['branch_name']); ?>
                </option>
              <?php endwhile; ?>
            <?php endif; ?>
          </select>
        </div>
        <div class="form-group col-md-3 d-flex align-items-end">
          <button type="submit" class="btn btn-primary btn-block">
            <i class="fas fa-filter mr-1"></i> Apply Filters
          </button>
        </div>
      </div>
      <div class="form-row">
        <div class="col-md-3">
          <a href="report.php" class="btn btn-secondary btn-block">
            <i class="fas fa-undo mr-1"></i> Reset Filters
          </a>
        </div>
      </div>
    </form>
  </div>

  <!-- Stats Grid (cards are full clickable links) -->
  <div class="stats">

    <a class="stat-card stat-pending" href="pending_with_branch_head.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&branch_id=<?php echo urlencode($branch_id); ?>">
      <div class="stat-body">
        <div>
          <div class="stat-label">Pending</div>
          <div class="stat-value"><?php echo number_format($pending_count); ?></div>
        </div>
        <div class="stat-icon"><i class="fas fa-hourglass-half"></i></div>
      </div>
    </a>

    <a class="stat-card stat-received" href="received_not_forward_staff.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&branch_id=<?php echo urlencode($branch_id); ?>">
      <div class="stat-body">
        <div>
          <div class="stat-label">Received</div>
          <div class="stat-value"><?php echo number_format($received_count); ?></div>
        </div>
        <div class="stat-icon"><i class="fas fa-inbox"></i></div>
      </div>
    </a>

    <a class="stat-card stat-seen" href="seen_letters.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&branch_id=<?php echo urlencode($branch_id); ?>">
      <div class="stat-body">
        <div>
          <div class="stat-label">Seen</div>
          <div class="stat-value"><?php echo number_format($seen_count); ?></div>
        </div>
        <div class="stat-icon"><i class="fas fa-eye"></i></div>
      </div>
    </a>

    <a class="stat-card stat-action" href="action_yes_letters.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&branch_id=<?php echo urlencode($branch_id); ?>">
      <div class="stat-body">
        <div>
          <div class="stat-label">Action</div>
          <div class="stat-value"><?php echo number_format($action_count); ?></div>
        </div>
        <div class="stat-icon"><i class="fas fa-check-circle"></i></div>
      </div>
    </a>

    <a class="stat-card stat-noaction" href="seen_letters.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&branch_id=<?php echo urlencode($branch_id); ?>">
      <div class="stat-body">
        <div>
          <div class="stat-label">No Action</div>
          <div class="stat-value"><?php echo number_format($no_action_count); ?></div>
        </div>
        <div class="stat-icon"><i class="fas fa-minus-circle"></i></div>
      </div>
    </a>

    <a class="stat-card stat-notseen" href="not_seen_letters.php?start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&branch_id=<?php echo urlencode($branch_id); ?>">
      <div class="stat-body">
        <div>
          <div class="stat-label">Not Seen</div>
          <div class="stat-value"><?php echo number_format($not_seen_count); ?></div>
        </div>
        <div class="stat-icon"><i class="fas fa-eye-slash"></i></div>
      </div>
    </a>

  </div>

  <!-- Role-based Back Button (bottom) -->
  <div class="mb-3">
    <?php if ($_SESSION['role'] == 'letter_admin'): ?>
      <a href="letter_admin_dashboard.php" class="btn btn-outline-primary">
        <i class="fas fa-arrow-left mr-1"></i> Back to Letter Admin Dashboard
      </a>
    <?php elseif ($_SESSION['role'] == 'super_admin'): ?>
      <a href="super_admin_dashboard.php" class="btn btn-outline-primary">
        <i class="fas fa-arrow-left mr-1"></i> Back to Super Admin Dashboard
      </a>
    <?php endif; ?>
  </div>

</div>

<!-- Footer -->
<footer>
  <div class="container">
    <small>&copy; 2025 Valvettiturai-Urban Council</small>
  </div>
</footer>

<!-- Bootstrap JS and dependencies -->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
</body>
</html>
