<?php
// Include the database connection file
include('db_connection.php');

// Fetch files from the database
$query = "SELECT fm.*, b.branch_name, u.username AS user_name
          FROM file_management fm
          JOIN branches b ON fm.branch_id = b.branch_id
          JOIN users u ON fm.user_id = u.user_id";
$result = $conn->query($query);

// Fetch users from the database for the dropdown
$user_query = "SELECT user_id, username FROM users WHERE status = 'active'";
$user_result = $conn->query($user_query);

// Handle forward files functionality
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['selected_files']) && isset($_POST['forward_to_user'])) {
    $selected_files = $_POST['selected_files'];  // Array of selected file IDs
    $forward_to_user = $_POST['forward_to_user'];  // User ID to forward to
    
    if (!empty($selected_files)) {
        // Update the 'user_id' field in the 'file_management' table
        $placeholders = implode(',', array_fill(0, count($selected_files), '?'));
        $query = "UPDATE file_management SET user_id = ? WHERE file_id IN ($placeholders)";
        
        // Prepare and bind parameters
        $stmt = $conn->prepare($query);
        
        // Prepare params
        $params = array_merge([$forward_to_user], $selected_files);
        $stmt->bind_param(str_repeat('i', count($params)), ...$params);
        
        // Execute the statement
        if ($stmt->execute()) {
            // After the successful update, redirect to the same page to refresh
            header("Location: " . $_SERVER['PHP_SELF']);
            exit();
        } else {
            echo "<p style='color:red;'>Error executing update: " . $stmt->error . "</p>";
        }

        $stmt->close();
    } else {
        echo "<p style='color:red;'>Please select at least one file to forward.</p>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>File Management</title>
    
    <!-- Include Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Include DataTables CSS -->
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
    
    <!-- Include jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    
    <!-- Include DataTables JS -->
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    
    <!-- Include Select2 CSS and JS for searchable dropdown -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/select2@4.0.13/dist/js/select2.min.js"></script>

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
        }
        .container {
            width: 85%;
            margin: 50px auto;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        table {
            width: 100%;
            margin-bottom: 20px;
            border-collapse: collapse;
        }
        table th, table td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: left;
        }
        table th {
            background-color: #f4f4f4;
        }
        select, button {
            padding: 10px;
            font-size: 16px;
            margin: 10px 0;
            width: 100%;
            box-sizing: border-box;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
        h2 {
            text-align: center;
            color: #333;
        }
        .back-button {
            background-color: #f44336;
            color: white;
            padding: 10px 20px;
            text-decoration: none;
            border-radius: 5px;
            display: inline-block;
            margin-bottom: 20px;
        }
        .back-button:hover {
            background-color: #e53935;
        }
    </style>
</head>
<body>

<div class="container">
    <!-- Back Button -->
    <a href="super_admin_dashboard.php" class="back-button">Back to Dashboard</a>

    <h2>File Management</h2>

    <form method="POST" action="" id="fileForwardForm">

        <!-- Select All Checkbox -->
        <label>
            <input type="checkbox" id="selectAll" /> Select All
        </label>

        <table id="lettersTable" class="display">
            <thead>
                <tr>
                    <th>Select</th>
                    <th>File Name</th>
                    <th>File Number</th>
                    <th>Subject</th>
                    <th>Branch</th>
                    <th>User</th>
                    <th>Status</th>
                    <th>Assigned User</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                        echo "<tr>";
                        echo "<td><input type='checkbox' name='selected_files[]' value='{$row['file_id']}' /></td>";
                        echo "<td>{$row['file_name']}</td>";
                        echo "<td>{$row['file_number']}</td>";
                        echo "<td>{$row['subject']}</td>";
                        echo "<td>{$row['branch_name']}</td>";
                        echo "<td>{$row['user_name']}</td>";
                        echo "<td>{$row['status']}</td>";
                        echo "<td>{$row['user_name']}</td>";
                        echo "</tr>";
                    }
                } else {
                    echo "<tr><td colspan='8'>No files found.</td></tr>";
                }
                ?>
            </tbody>
        </table>

        <label for="forward_to_user">Select User to Forward To:</label>
        <select name="forward_to_user" id="forward_to_user">
            <option value="">Select User</option>
            <?php
            if ($user_result->num_rows > 0) {
                while ($user = $user_result->fetch_assoc()) {
                    echo "<option value='{$user['user_id']}'>{$user['username']}</option>";
                }
            } else {
                echo "<option value=''>No users available</option>";
            }
            ?>
        </select>

        <br><br>
        <button type="button" id="confirmForwardBtn">Forward Files</button>
    </form>
</div>

<script>
    // Initialize the DataTable
    $(document).ready(function () {
        $('#lettersTable').DataTable({
            "paging": true,
            "searching": true,
            "ordering": true,
            "info": true
        });

        // Select All checkbox functionality
        $('#selectAll').on('click', function () {
            var isChecked = $(this).prop('checked');
            $('#lettersTable input[type="checkbox"]').prop('checked', isChecked);
        });

        // Initialize Select2 for searchable dropdown
        $('#forward_to_user').select2({
            placeholder: "Search for a user",
            allowClear: true
        });

        // Forward button confirmation
        $('#confirmForwardBtn').on('click', function () {
            // Check if files are selected
            var selectedFiles = $('input[name="selected_files[]"]:checked').length;
            if (selectedFiles > 0) {
                // Show confirmation prompt
                var confirmation = confirm('Are you sure you want to forward the selected files?');
                if (confirmation) {
                    // Submit the form if confirmed
                    $('#fileForwardForm').submit();
                }
            } else {
                alert('Please select at least one file to forward.');
            }
        });
    });
</script>

</body>
</html>
