<?php
// Include the database connection file
include('db_connection.php');

// Start the session to check the logged-in user's details
session_start();

// Ensure the user is logged in
if (!isset($_SESSION['user_id'])) {
    // Redirect to the login page if the user is not logged in
    header("Location: login.php");
    exit;
}

// Get the logged-in user's details from the session
$user_id = $_SESSION['user_id'];
$role = $_SESSION['role'];  // Get the role from the session

// Check if the logged-in user is a staff_user
if ($role !== 'staff_user') {
    // Redirect to the dashboard or another page if the user is not a staff_user
    header("Location: unauthorized.php");  // You can change the redirect page as needed
    exit;
}

// Ensure the file_id is provided
if (!isset($_GET['file_id'])) {
    echo "<p style='color:red;'>File ID not specified.</p>";
    exit;
}

$file_id = $_GET['file_id'];

// Fetch the file details from the database based on file_id
$query = "SELECT fm.*, b.branch_name, u.username AS user_name 
          FROM file_management fm
          JOIN branches b ON fm.branch_id = b.branch_id
          JOIN users u ON fm.user_id = u.user_id
          WHERE fm.file_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $file_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $file = $result->fetch_assoc();
} else {
    echo "<p style='color:red;'>File not found.</p>";
    exit;
}

// Handle form submission for updating file details
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $file_name = $_POST['file_name'];
    $file_number = $_POST['file_number'];
    $subject = $_POST['subject'];
    $branch_id = $_POST['branch_id'];
    $user_id = $_POST['user_id'];
    $cupboard_name = $_POST['cupboard_name'];
    $rack_name = $_POST['rack_name'];
    $folder_name = $_POST['folder_name'];
    $file_order_number = $_POST['file_order_number'];
    $status = $_POST['status'];

    // Update the file in the database
    $update_query = "UPDATE file_management SET 
                     file_name = ?, file_number = ?, subject = ?, branch_id = ?, user_id = ?, 
                     cupboard_name = ?, rack_name = ?, folder_name = ?, file_order_number = ?, status = ? 
                     WHERE file_id = ?";

    $stmt = $conn->prepare($update_query);
    $stmt->bind_param("sssiisssssi", $file_name, $file_number, $subject, $branch_id, $user_id,
                      $cupboard_name, $rack_name, $folder_name, $file_order_number, $status, $file_id);

    if ($stmt->execute()) {
        echo "<p style='color:green;'>File updated successfully.</p>";
        // Redirect to the file management view page after successful update
        header("Location: file_management_view.php");
        exit;
    } else {
        echo "<p style='color:red;'>Error updating file: " . $stmt->error . "</p>";
    }
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit File Management</title>
    
    <!-- Include Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            width: 60%;
            margin: 50px auto;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            color: #333;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-control {
            width: 100%;
        }
    </style>
</head>
<body>

<div class="container">
    <h2>Edit File Details</h2>

    <form method="POST" action="">

        <div class="form-group">
            <label for="file_name">File Name</label>
            <input type="text" class="form-control" name="file_name" id="file_name" value="<?= $file['file_name'] ?>" required>
        </div>

        <div class="form-group">
            <label for="file_number">File Number</label>
            <input type="text" class="form-control" name="file_number" id="file_number" value="<?= $file['file_number'] ?>" required>
        </div>

        <div class="form-group">
            <label for="subject">Subject</label>
            <textarea class="form-control" name="subject" id="subject" rows="3" required><?= $file['subject'] ?></textarea>
        </div>

        <div class="form-group">
            <label for="branch_id">Branch</label>
            <select class="form-control" name="branch_id" id="branch_id" required>
                <?php
                // Fetch all branches for the dropdown
                $branch_query = "SELECT * FROM branches";
                $branch_result = $conn->query($branch_query);
                while ($branch = $branch_result->fetch_assoc()) {
                    $selected = ($branch['branch_id'] == $file['branch_id']) ? 'selected' : '';
                    echo "<option value='{$branch['branch_id']}' {$selected}>{$branch['branch_name']}</option>";
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="user_id">User</label>
            <select class="form-control" name="user_id" id="user_id" required>
                <?php
                // Fetch all users for the dropdown
                $user_query = "SELECT * FROM users WHERE status = 'active'";
                $user_result = $conn->query($user_query);
                while ($user = $user_result->fetch_assoc()) {
                    $selected = ($user['user_id'] == $file['user_id']) ? 'selected' : '';
                    echo "<option value='{$user['user_id']}' {$selected}>{$user['username']}</option>";
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label for="cupboard_name">Cupboard Name</label>
            <input type="text" class="form-control" name="cupboard_name" id="cupboard_name" value="<?= $file['cupboard_name'] ?>" required>
        </div>

        <div class="form-group">
            <label for="rack_name">Rack Name</label>
            <input type="text" class="form-control" name="rack_name" id="rack_name" value="<?= $file['rack_name'] ?>" required>
        </div>

        <div class="form-group">
            <label for="folder_name">Folder Name</label>
            <input type="text" class="form-control" name="folder_name" id="folder_name" value="<?= $file['folder_name'] ?>" required>
        </div>

        <div class="form-group">
            <label for="file_order_number">File Order Number</label>
            <input type="number" class="form-control" name="file_order_number" id="file_order_number" value="<?= $file['file_order_number'] ?>" required>
        </div>

        <div class="form-group">
            <label for="status">Status</label>
            <select class="form-control" name="status" id="status" required>
                <option value="Active" <?= ($file['status'] == 'Active') ? 'selected' : '' ?>>Active</option>
                <option value="Archived" <?= ($file['status'] == 'Archived') ? 'selected' : '' ?>>Archived</option>
                <option value="Under Review" <?= ($file['status'] == 'Under Review') ? 'selected' : '' ?>>Under Review</option>
            </select>
        </div>

        <button type="submit" class="btn btn-success btn-block">Update File</button>
    </form>
</div>

</body>
</html>
